//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

Item {
    implicitWidth  : icon.implicitWidth  + label.implicitWidth + 18
    implicitHeight : icon.implicitHeight + 6

    UiIcon {
        id : icon

        x        : y
        iconName : uiToolButton.iconName
        iconSize : uiToolButton.iconSize

        anchors.verticalCenter : parent.verticalCenter

        states : [
            State {
                name : "disabled"
                when : !uiToolButton.enabled

                PropertyChanges {
                    target   : icon
                    disabled : 1.0
                }
            },
            State {
                name : "highlight"
                when : uiToolButton.pressed || uiToolButton.down

                PropertyChanges {
                    target    : icon
                    highlight : 1.0
                }
            }
        ]
    }

    UiText {
        id : label

        anchors {
            verticalCenter : parent.verticalCenter
            left           : icon.right
            leftMargin     : 6
            right          : parent.right
            rightMargin    : 6
        }
        text      : uiToolButton.text
        highlight : uiToolButton.down || uiToolButton.pressed
    }
}
